/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import processing.core.PApplet;

public class ChromosomeList {
    int length;
    Chromosome[] list;
    int snpCount;
    double[] badPercent;

    public void add(Chromosome chromosome) {
        if (this.list == null) {
            this.list = new Chromosome[10];
        }
        if (this.length == this.list.length) {
            Chromosome[] chromosomeArray = new Chromosome[this.length * 2];
            System.arraycopy(this.list, 0, chromosomeArray, 0, this.length);
            this.list = chromosomeArray;
        }
        this.list[this.length++] = chromosome;
    }

    public ChromosomeList subset(int[] nArray) {
        ChromosomeList chromosomeList = new ChromosomeList();
        chromosomeList.length = this.length;
        chromosomeList.list = new Chromosome[this.length];
        int n = 0;
        while (n < this.length) {
            chromosomeList.list[n] = this.list[n].subset(nArray);
            ++n;
        }
        chromosomeList.snpCount = nArray.length;
        chromosomeList.badPercent = new double[chromosomeList.snpCount];
        n = 0;
        while (n < chromosomeList.snpCount) {
            chromosomeList.badPercent[n] = this.badPercent[nArray[n]];
            ++n;
        }
        return chromosomeList;
    }

    public ChromosomeList subset(int n, int n2) {
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = n + n3;
            ++n3;
        }
        return this.subset(nArray);
    }

    public ChromosomeList subset(String string) {
        ChromosomeList chromosomeList = new ChromosomeList();
        int n = 0;
        Chromosome[] chromosomeArray = new Chromosome[this.length];
        int n2 = 0;
        while (n2 < this.length) {
            if (string.equals("ceph") && this.list[n2].pedigree.length() == 4 || string.equals("yor") && this.list[n2].pedigree.startsWith("YOR") || string.equals("chi") && this.list[n2].individual.startsWith("RB")) {
                chromosomeArray[n++] = this.list[n2];
            }
            ++n2;
        }
        chromosomeList.length = n;
        chromosomeList.list = new Chromosome[n];
        System.arraycopy(chromosomeArray, 0, chromosomeList.list, 0, n);
        chromosomeList.snpCount = this.snpCount;
        chromosomeList.calcBadPercent();
        return chromosomeList;
    }

    public void calcBadPercent() {
        this.badPercent = new double[this.snpCount];
        int n = 0;
        while (n < this.snpCount) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.length) {
                if (this.list[n3].genotypes[n] == 0) {
                    ++n2;
                }
                ++n3;
            }
            this.badPercent[n] = (double)n2 / (double)this.length;
            ++n;
        }
    }

    public void swap(int n, int n2) {
        Chromosome chromosome = this.list[n];
        this.list[n] = this.list[n2];
        this.list[n2] = chromosome;
    }

    public void sort() {
        Sort sort = new Sort(){

            public final int count() {
                return ChromosomeList.this.length;
            }

            public final float compare(int n, int n2) {
                return new String(ChromosomeList.this.list[n].genotypes).compareTo(new String(ChromosomeList.this.list[n2].genotypes));
            }

            public final void swap(int n, int n2) {
                ChromosomeList.this.swap(n, n2);
            }
        };
        sort.run();
    }

    public ChromosomeList() {
    }

    public ChromosomeList(InputStream inputStream) throws IOException {
        String[] stringArray = PApplet.loadStrings(inputStream);
        Vector<Chromosome> vector = new Vector<Chromosome>();
        int[] nArray = null;
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String[] stringArray2 = PApplet.split(string);
            if (this.snpCount == 0) {
                this.snpCount = stringArray2.length - 2;
                nArray = new int[this.snpCount];
                this.badPercent = new double[this.snpCount];
            }
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            byte[] byArray = new byte[this.snpCount];
            int n2 = 0;
            while (n2 < this.snpCount) {
                byArray[n2] = (byte)stringArray2[n2 + 2].charAt(0);
                if (byArray[n2] != 104) {
                    int n3 = n2;
                    byArray[n3] = (byte)(byArray[n3] - 48);
                }
                if (byArray[n2] == 0) {
                    int n4 = n2;
                    nArray[n4] = nArray[n4] + 1;
                }
                ++n2;
            }
            vector.add(new Chromosome(string2, string3, byArray));
            ++n;
        }
        this.list = new Chromosome[vector.size()];
        vector.copyInto(this.list);
        this.length = this.list.length;
        n = 0;
        while (n < this.snpCount) {
            this.badPercent[n] = (double)nArray[n] / (double)this.length;
            ++n;
        }
    }
}

