/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import processing.core.PApplet;
import processing.pdf.PGraphicsPDF;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class bifurcator
extends PApplet {
    Branch leftBranch;
    Branch rightBranch;
    OratorACGT orator;
    int MAX_COUNT;
    int maxCount;
    String filename;
    int corePosition;
    int coreLength;
    int leftLength;
    int rightLength;
    float leftOffset;
    float rightOffset;
    float offset;
    String positionsFilename;
    int[] positions;
    float[] npositions;
    float[] positionX;
    boolean actualPositions;
    int coreCount;
    ChromosomeList[] chroms;
    int coreIndex;
    float VSIZE;
    float TOP;
    float HIGH;
    float LEFT;
    float WIDE;
    boolean allText;
    boolean branchText;
    float FONT_SIZE;
    float VGAP;
    float TEXT_GAP;
    float runningY;

    public void setup() {
        Object object;
        if (this.args.length < 7) {
            bifurcator.println("Bifurcator by Ben Fry");
            bifurcator.println();
            bifurcator.println("This application creates a bifurcation plot from a set of");
            bifurcator.println("haplotype data. Given a set of SNPs that define a \"core\"");
            bifurcator.println("region, a tree is produced that shows how the genotypes of");
            bifurcator.println("a set of individuals bifurcate and differentiate themselves");
            bifurcator.println("from that point.");
            bifurcator.println();
            bifurcator.println("usage: [--actual-positions] [--less-text] <phased_file> <position_file> <core_position> <core_length> <left_branch_length> <right_branch_length> <font_size>");
            bifurcator.println();
            bifurcator.println("Example: java -jar bifurcator.jar ceph3.phase ceph3.pos 32 1 10 10 5");
            bifurcator.println("(the download includes the input files for this example)");
            bifurcator.println();
            bifurcator.println("--actual-positions  will horizontally place SNPs based on");
            bifurcator.println("                    genomic position instead of equidistant");
            bifurcator.println();
            bifurcator.println("--less-text         this options shuts of text for anything");
            bifurcator.println("                    except for the core region.");
            bifurcator.println();
            bifurcator.println("The <phased_file> parameter should be a file that contains");
            bifurcator.println("phased haplotype data. The first two columns of the data");
            bifurcator.println("are ignored. Additional columns are expected to contain");
            bifurcator.println("1, 2, 3, or 4 to signify A, C, G, or T.");
            bifurcator.println();
            bifurcator.println("The <position_file> parameter should specify a file that");
            bifurcator.println("lists the position of each SNP on its own line.");
            bifurcator.println();
            bifurcator.println("If you use this software for publication, please send a note");
            bifurcator.println("with the reference or a link. When citing this software, use:");
            bifurcator.println("Fry, B. Computational Information Design.");
            bifurcator.println("Ph.D. Thesis, Massachusetts Institute of Technology, (2004).");
            bifurcator.println();
            bifurcator.println("Bifurcator r21, released 1 October 2006");
            bifurcator.println("(c) Ben Fry (mail at benfry dot com)");
            bifurcator.println("http://benfry.com/bifurcator");
            bifurcator.println();
            System.exit(0);
        }
        while (this.args[0].startsWith("--")) {
            if (this.args[0].equals("--actual-positions")) {
                this.actualPositions = true;
            } else if (this.args[0].equals("--less-text")) {
                this.branchText = false;
            } else {
                System.err.println(this.args[0] + " is not understood");
                System.exit(1);
            }
            this.args = bifurcator.subset(this.args, 1);
        }
        String string = null;
        int n = this.args[0].lastIndexOf(46);
        string = n == -1 ? this.args[0] + ".pdf" : this.args[0].substring(0, n) + ".pdf";
        this.size(612, 792, "processing.pdf.PGraphicsPDF", string);
        this.filename = this.args[0];
        this.positionsFilename = this.args[1];
        this.corePosition = bifurcator.parseInt(this.args[2]) - 1;
        this.coreLength = bifurcator.parseInt(this.args[3]);
        this.leftLength = bifurcator.parseInt(this.args[4]);
        this.rightLength = bifurcator.parseInt(this.args[5]);
        this.FONT_SIZE = bifurcator.parseInt(this.args[6]);
        this.VGAP = this.FONT_SIZE * 1.25f;
        this.TEXT_GAP = this.VGAP * 2.0f;
        this.textAlign(3);
        this.HIGH = (float)this.height - this.TOP * 2.0f;
        this.WIDE = (float)this.width - this.LEFT * 2.0f;
        try {
            String string2;
            object = new ChromosomeList(this.openStream(this.filename));
            ChromosomeList chromosomeList = ((ChromosomeList)object).subset(this.corePosition - this.leftLength, this.leftLength + this.coreLength + this.rightLength);
            int[] nArray = new int[this.coreLength];
            int n2 = 0;
            while (n2 < this.coreLength) {
                nArray[n2] = this.leftLength + n2;
                ++n2;
            }
            StrIntTable strIntTable = new StrIntTable();
            int n3 = 0;
            while (n3 < chromosomeList.length) {
                string2 = chromosomeList.list[n3].getString(nArray);
                strIntTable.increment(string2);
                ++n3;
            }
            this.coreCount = strIntTable.count;
            this.chroms = new ChromosomeList[this.coreCount];
            n3 = 0;
            while (n3 < this.coreCount) {
                this.chroms[n3] = new ChromosomeList();
                ++n3;
            }
            n3 = 0;
            while (n3 < chromosomeList.length) {
                string2 = chromosomeList.list[n3].getString(nArray);
                int n4 = strIntTable.index(string2);
                this.chroms[n4].add(chromosomeList.list[n3]);
                ++n3;
            }
        }
        catch (IOException iOException) {
            this.die("problem loading snps", iOException);
        }
        object = bifurcator.parseInt(this.loadStrings(this.positionsFilename));
        this.positions = bifurcator.subset((int[])object, this.corePosition - this.leftLength, this.leftLength + this.coreLength + this.rightLength);
        float f = this.positions[0];
        float f2 = (float)this.positions[this.positions.length - 1] - f;
        this.npositions = new float[this.positions.length];
        this.positionX = new float[this.positions.length];
        int n5 = 0;
        while (n5 < this.positions.length) {
            this.npositions[n5] = ((float)this.positions[n5] - f) / f2;
            ++n5;
        }
        this.reposition();
        this.setCore(0);
    }

    public void decompiling_code_is_for_wankers() {
    }

    protected void setCore(int n) {
        if (n >= this.coreCount) {
            return;
        }
        this.coreIndex = n;
        ChromosomeList chromosomeList = this.chroms[this.coreIndex];
        this.leftBranch = new Branch(chromosomeList.list[0], this.leftLength, true);
        this.rightBranch = new Branch(chromosomeList.list[0], this.leftLength + this.coreLength - 1, false);
        this.maxCount = chromosomeList.length;
        int n2 = 1;
        while (n2 < this.maxCount) {
            this.leftBranch.apply(chromosomeList.list[n2], this.leftLength, true);
            this.rightBranch.apply(chromosomeList.list[n2], this.leftLength + this.coreLength - 1, false);
            ++n2;
        }
        this.leftBranch.findBiggest();
        this.rightBranch.findBiggest();
        this.runningY = this.TOP;
        this.leftBranch.calc();
        float f = this.runningY;
        this.runningY = this.TOP;
        this.rightBranch.calc();
        float f2 = this.runningY;
        if (f > f2) {
            this.leftOffset = (this.HIGH - f) / 2.0f;
            float f3 = this.leftBranch.y1 + this.leftOffset;
            this.rightOffset = f3 - this.rightBranch.y1;
        } else {
            this.rightOffset = (this.HIGH - f2) / 2.0f;
            float f4 = this.rightBranch.y1 + this.rightOffset;
            this.leftOffset = f4 - this.leftBranch.y1;
        }
    }

    public void keyPressed() {
        if (this.keyCode == 27) {
            this.exit();
            return;
        }
        if (this.keyCode == 37) {
            if (this.coreIndex > 0) {
                this.setCore(this.coreIndex - 1);
            }
        } else if (this.keyCode == 39) {
            if (this.coreIndex < this.coreCount - 1) {
                this.setCore(this.coreIndex + 1);
            }
        } else if (this.key == 't') {
            this.allText ^= true;
            if (this.allText) {
                this.VSIZE = 2.0f;
                this.VGAP = 15.0f;
            } else {
                this.VSIZE = 4;
                this.VGAP = 6.0f;
            }
            this.setCore(this.coreIndex);
        } else if (this.key == '-') {
            if (this.maxCount > 1) {
                --this.maxCount;
            }
            this.setCore(this.coreIndex);
        } else if (this.key == '=') {
            if (this.maxCount < this.MAX_COUNT - 2) {
                ++this.maxCount;
            }
            this.setCore(this.coreIndex);
        } else if (this.key == 'p') {
            this.actualPositions ^= true;
            this.reposition();
        }
        this.redraw();
    }

    void reposition() {
        int n = 0;
        while (n < this.positions.length) {
            this.positionX[n] = this.actualPositions ? this.LEFT + this.npositions[n] * this.WIDE : this.LEFT + this.WIDE * ((float)n / (float)(this.positions.length - 1));
            ++n;
        }
    }

    public void draw() {
        int n = 0;
        while (n < this.coreCount) {
            this.setCore(n);
            this.background(255);
            this.noStroke();
            this.fill(128);
            this.offset = this.leftOffset;
            this.fill(64);
            int n2 = this.leftLength + 1;
            while (n2 < this.leftLength + this.coreLength - 1) {
                this.orator.draw((char)Chromosome.acgt[this.chroms[this.coreIndex].list[0].genotypes[n2]], (int)this.positionX[n2], this.leftBranch.y1 + this.offset - 2.0f, this.FONT_SIZE, this.g.textAlign, this.g);
                ++n2;
            }
            float f = (int)this.positionX[this.leftLength];
            float f2 = (int)this.positionX[this.leftLength + this.coreLength - 1];
            f2 -= 0.5f;
            this.strokeWeight(0.5f);
            if (f < f2) {
                this.noFill();
                this.stroke(180);
                this.beginShape(128);
                this.vertex(f, this.leftBranch.y1 + this.offset + this.g.strokeWeight / 2.0f);
                this.vertex(f2, this.leftBranch.y1 + this.offset + this.g.strokeWeight / 2.0f);
                this.vertex(f2, this.leftBranch.y2 + this.offset - this.g.strokeWeight / 2.0f);
                this.vertex(f, this.leftBranch.y2 + this.offset - this.g.strokeWeight / 2.0f);
                this.endShape();
            }
            this.noStroke();
            this.pushMatrix();
            this.translate(0.0f, this.leftOffset);
            this.leftBranch.draw();
            this.popMatrix();
            this.pushMatrix();
            this.translate(0.0f, this.rightOffset);
            this.offset = this.rightOffset;
            this.rightBranch.draw();
            this.popMatrix();
            if (n != this.coreCount - 1) {
                ((PGraphicsPDF)this.g).nextPage();
            }
            ++n;
        }
        if (this.g instanceof PGraphicsPDF) {
            this.exit();
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "bifurcator";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        PApplet.main(stringArray2);
    }

    private final /* synthetic */ void this() {
        this.orator = new OratorACGT();
        this.MAX_COUNT = 96;
        this.maxCount = 1;
        this.VSIZE = 2.0f;
        this.TOP = 50.0f;
        this.LEFT = 50.0f;
        this.allText = false;
        this.branchText = true;
    }

    public bifurcator() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Branch {
        char snp;
        int count;
        int index;
        boolean biggest;
        Branch top;
        Branch bot;
        float y1;
        float y2;

        public void findBiggest() {
            if (this.top == null && this.bot == null) {
                return;
            }
            if (this.top == null) {
                this.bot.biggest = true;
                this.bot.findBiggest();
            } else if (this.bot == null) {
                this.top.biggest = true;
                this.top.findBiggest();
            } else if (this.top.count > this.bot.count) {
                this.top.biggest = true;
                this.top.findBiggest();
            } else {
                this.bot.biggest = true;
                this.bot.findBiggest();
            }
        }

        public void print() {
            this.print("");
        }

        public void print(String string) {
            bifurcator.println(string + (char)Chromosome.acgt[this.snp] + ' ' + this.count + " (" + this.index + ')');
            if (this.top != null) {
                this.top.print(string + "  ");
            }
            if (this.bot != null) {
                this.bot.print(string + "  ");
            }
        }

        public void apply(Chromosome chromosome, int n, boolean bl) {
            ++this.count;
            int n2 = n + (bl ? -1 : 1);
            if (n2 == -1 || n2 == chromosome.genotypes.length) {
                return;
            }
            if (this.top != null && this.top.snp == chromosome.genotypes[n2]) {
                this.top.apply(chromosome, n2, bl);
            } else if (this.bot != null && this.bot.snp == chromosome.genotypes[n2]) {
                this.bot.apply(chromosome, n2, bl);
            } else if (this.top == null) {
                this.top = new Branch((char)chromosome.genotypes[n2], n2);
                this.top.apply(chromosome, n2, bl);
            } else if (this.bot == null) {
                this.bot = new Branch((char)chromosome.genotypes[n2], n2);
                this.bot.apply(chromosome, n2, bl);
            }
        }

        public void calc() {
            if (this.top == null) {
                this.y1 = bifurcator.this.runningY;
                if (this.biggest) {
                    this.y1 += bifurcator.this.TEXT_GAP;
                }
                this.y2 = this.y1 + (float)this.count * bifurcator.this.VSIZE;
                bifurcator.this.runningY = this.y2 + bifurcator.this.VGAP;
            } else {
                if (this.top != null) {
                    this.top.calc();
                }
                if (this.bot != null) {
                    this.bot.calc();
                }
                if (this.top == null) {
                    this.y1 = this.bot.y1;
                    this.y2 = this.bot.y2;
                } else if (this.bot == null) {
                    this.y1 = this.top.y1;
                    this.y2 = this.top.y2;
                } else {
                    float f = this.top.y1;
                    float f2 = this.bot.y2;
                    float f3 = (float)this.count * bifurcator.this.VSIZE;
                    this.y1 = (f + f2) / 2.0f - f3 / 2.0f;
                    this.y2 = this.y1 + f3;
                }
            }
        }

        public void draw() {
            boolean bl;
            float f = (int)bifurcator.this.positionX[this.index];
            boolean bl2 = false;
            if (this.index == bifurcator.this.leftLength || this.index == bifurcator.this.leftLength + bifurcator.this.coreLength - 1) {
                bl2 = bl = true;
            }
            if (this.biggest && bifurcator.this.branchText || bifurcator.this.allText || bl) {
                bifurcator.this.fill(64);
                bifurcator.this.orator.draw((char)Chromosome.acgt[this.snp], f, this.y1 - 2.0f, bifurcator.this.FONT_SIZE, bifurcator.this.g.textAlign, bifurcator.this.g);
            }
            if (this.top == null) {
                return;
            }
            float f2 = (int)bifurcator.this.positionX[this.top.index];
            float f3 = this.index < this.top.index ? -0.5f : 0.5f;
            float f4 = this.y1;
            float f5 = f + 0.5f * ((f2 += f3) - f);
            if (this.top != null) {
                bifurcator.this.fill(this.top.biggest ? 80 : 180);
                bifurcator.this.beginShape();
                bifurcator.this.vertex(f, this.y1);
                bifurcator.this.bezierVertex(f5, this.y1, f5, this.top.y1, f2, this.top.y1);
                bifurcator.this.vertex(f2, this.top.y2);
                bifurcator.this.bezierVertex(f5, this.top.y2, f5, f4 += this.top.y2 - this.top.y1, f, f4);
                bifurcator.this.endShape();
            }
            if (this.bot != null) {
                bifurcator.this.fill(this.bot.biggest ? 80 : 180);
                bifurcator.this.beginShape();
                bifurcator.this.vertex(f, f4);
                bifurcator.this.bezierVertex(f5, f4, f5, this.bot.y1, f2, this.bot.y1);
                bifurcator.this.vertex(f2, this.bot.y2);
                bifurcator.this.bezierVertex(f5, this.bot.y2, f5, this.y2, f, this.y2);
                bifurcator.this.endShape();
            }
            if (this.top != null) {
                this.top.draw();
            }
            if (this.bot != null) {
                this.bot.draw();
            }
        }

        public Branch(Chromosome chromosome, int n, boolean bl) {
            this((char)chromosome.genotypes[n], n);
            this.apply(chromosome, n, bl);
        }

        public Branch(char c, int n) {
            this.snp = c;
            this.index = n;
        }
    }
}

