/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PLine;
import processing.core.PPolygon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PGraphics2D
extends PGraphics {
    static final int CVERTEX_ALLOC = 128;
    PPolygon polygon;
    PPolygon fpolygon;
    PPolygon spolygon;
    float[][] svertices;
    private PPolygon tpolygon;
    private int TPOLYGON_MAX_VERTICES;
    private int[] tpolygon_vertex_order;
    PLine line;
    boolean strokeChanged;
    boolean fillChanged;
    float[][] cvertex;
    int cvertexIndex;

    protected void allocate() {
        this.pixelCount = this.width * this.height;
        this.pixels = new int[this.pixelCount];
        this.backgroundColor |= 0xFF000000;
        int n = 0;
        while (n < this.pixelCount) {
            this.pixels[n] = this.backgroundColor;
            ++n;
        }
        if (this.mainDrawingSurface) {
            this.cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
            this.mis = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
            this.mis.setFullBufferUpdates(true);
            this.mis.setAnimated(true);
            this.image = Toolkit.getDefaultToolkit().createImage(this.mis);
        }
    }

    public void beginDraw() {
        this.insideResizeWait();
        this.insideDraw = true;
        if (!this.defaultsInited) {
            this.defaults();
            this.polygon = new PPolygon(this);
            this.fpolygon = new PPolygon(this);
            this.spolygon = new PPolygon(this);
            this.spolygon.vertexCount = 4;
            this.svertices = new float[2][];
        }
        this.resetMatrix();
        this.vertexCount = 0;
    }

    public void endDraw() {
        if (this.mis != null) {
            this.mis.newPixels(this.pixels, (ColorModel)this.cm, 0, this.width);
        }
        this.updatePixels();
        this.insideDraw = false;
    }

    public void beginShape(int n) {
        this.shape = n;
        this.vertexCount = 0;
        this.splineVertexCount = 0;
        this.polygon.reset(0);
        this.fpolygon.reset(4);
        this.spolygon.reset(4);
        this.polygon.interpUV = false;
    }

    public void vertex(float f, float f2) {
        float[] fArray = this.polygon.nextVertex();
        this.cvertexIndex = 0;
        fArray[9] = f;
        fArray[10] = f2;
        if (this.fill) {
            fArray[3] = this.fillR;
            fArray[4] = this.fillG;
            fArray[5] = this.fillB;
            fArray[6] = this.fillA;
        }
        if (this.stroke) {
            fArray[12] = this.strokeR;
            fArray[13] = this.strokeG;
            fArray[14] = this.strokeB;
            fArray[15] = this.strokeA;
            fArray[16] = this.strokeWeight;
        }
        if (this.textureImage != null) {
            fArray[7] = this.textureU;
            fArray[8] = this.textureV;
        }
    }

    public void vertex(float f, float f2, float f3, float f4) {
        this.textureVertex(f3, f4);
        this.vertex(f, f2);
    }

    public void vertex(float f, float f2, float f3) {
        this.depthErrorXYZ("vertex");
    }

    public void vertex(float f, float f2, float f3, float f4, float f5) {
        this.depthErrorXYZ("vertex");
    }

    public void endShape(int n) {
        int n2;
        int n3 = this.polygon.vertexCount;
        float[][] fArray = this.polygon.vertices;
        if (this.untransformed()) {
            n2 = 0;
            while (n2 < n3) {
                fArray[n2][0] = fArray[n2][9];
                fArray[n2][1] = fArray[n2][10];
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < n3) {
                fArray[n2][0] = this.m00 * fArray[n2][9] + this.m01 * fArray[n2][10] + this.m03;
                fArray[n2][1] = this.m10 * fArray[n2][9] + this.m11 * fArray[n2][10] + this.m13;
                ++n2;
            }
        }
        if (this.polygon.interpUV) {
            this.fpolygon.texture(this.textureImage);
        }
        this.spolygon.interpARGB = this.strokeChanged;
        this.fpolygon.interpARGB = this.fillChanged;
        switch (this.shape) {
            case 16: {
                if (this.untransformed() && this.strokeWeight == 1.0f) {
                    if (!this.strokeChanged) {
                        int n4 = 0;
                        while (n4 < n3) {
                            this.thin_point((int)fArray[n4][0], (int)fArray[n4][1], 0.0f, this.strokeColor);
                            ++n4;
                        }
                    } else {
                        int n5 = 0;
                        while (n5 < n3) {
                            this.thin_point((int)fArray[n5][0], (int)fArray[n5][1], 0.0f, PGraphics2D.float_color(fArray[n5][12], fArray[n5][13], fArray[n5][14]));
                            ++n5;
                        }
                    }
                } else {
                    float[] fArray2 = fArray[0];
                    int n6 = 0;
                    while (n6 < n3) {
                        float[] fArray3 = fArray[n6];
                        if (n6 == 0 || this.strokeChanged) {
                            this.calc_lighting(fArray3[12], fArray3[13], fArray3[14], fArray3[0], fArray3[1], fArray3[2], fArray3[17], fArray3[18], fArray3[19], fArray2, 3);
                        }
                        this.thick_point(fArray3[0], fArray3[1], fArray3[2], fArray2[3], fArray2[4], fArray2[5], fArray2[15]);
                        ++n6;
                    }
                }
                break;
            }
            case 32: {
                if (!this.stroke) {
                    return;
                }
                if (n == 2) {
                    float[] fArray4 = this.polygon.vertices[0];
                    float[] fArray5 = this.polygon.nextVertex();
                    ++n3;
                    fArray5[0] = fArray4[0];
                    fArray5[1] = fArray4[1];
                    fArray5[2] = fArray4[2];
                    fArray5[12] = fArray4[12];
                    fArray5[13] = fArray4[13];
                    fArray5[14] = fArray4[14];
                }
                int n7 = 0;
                if (this.shape == 32) {
                    n7 = 1;
                }
                n2 = n7 + 1;
                this.draw_lines(fArray, n3 - 1, 1, n2, 0);
                break;
            }
            case 64: 
            case 65: {
                int n8 = n2 = this.shape == 64 ? 3 : 1;
                if (this.fill) {
                    this.fpolygon.vertexCount = 3;
                    int n9 = 0;
                    while (n9 < n3 - 2) {
                        int n10 = 0;
                        while (n10 < 3) {
                            this.fpolygon.vertices[n10][3] = fArray[n9 + n10][3];
                            this.fpolygon.vertices[n10][4] = fArray[n9 + n10][4];
                            this.fpolygon.vertices[n10][5] = fArray[n9 + n10][5];
                            this.fpolygon.vertices[n10][6] = fArray[n9 + n10][6];
                            this.fpolygon.vertices[n10][0] = fArray[n9 + n10][0];
                            this.fpolygon.vertices[n10][1] = fArray[n9 + n10][1];
                            this.fpolygon.vertices[n10][2] = fArray[n9 + n10][2];
                            if (this.polygon.interpUV) {
                                this.fpolygon.vertices[n10][7] = fArray[n9 + n10][7];
                                this.fpolygon.vertices[n10][8] = fArray[n9 + n10][8];
                            }
                            ++n10;
                        }
                        this.fpolygon.render();
                        n9 += n2;
                    }
                }
                if (!this.stroke) break;
                if (this.shape == 65) {
                    this.draw_lines(fArray, n3 - 1, 1, 1, 0);
                } else {
                    this.draw_lines(fArray, n3 - 1, 1, 1, 3);
                }
                this.draw_lines(fArray, n3 - 2, 2, n2, 0);
                break;
            }
            case 128: 
            case 129: {
                int n11 = n2 = this.shape == 128 ? 4 : 2;
                if (this.fill) {
                    this.fpolygon.vertexCount = 4;
                    int n12 = 0;
                    while (n12 < n3 - 3) {
                        int n13 = 0;
                        while (n13 < 4) {
                            this.fpolygon.vertices[n13][3] = fArray[n12 + n13][3];
                            this.fpolygon.vertices[n13][4] = fArray[n12 + n13][4];
                            this.fpolygon.vertices[n13][5] = fArray[n12 + n13][5];
                            this.fpolygon.vertices[n13][6] = fArray[n12 + n13][6];
                            this.fpolygon.vertices[n13][0] = fArray[n12 + n13][0];
                            this.fpolygon.vertices[n13][1] = fArray[n12 + n13][1];
                            this.fpolygon.vertices[n13][2] = fArray[n12 + n13][2];
                            if (this.polygon.interpUV) {
                                this.fpolygon.vertices[n13][7] = fArray[n12 + n13][7];
                                this.fpolygon.vertices[n13][8] = fArray[n12 + n13][8];
                            }
                            ++n13;
                        }
                        this.fpolygon.render();
                        n12 += n2;
                    }
                }
                if (!this.stroke) break;
                if (this.shape == 129) {
                    this.draw_lines(fArray, n3 - 1, 1, 1, 0);
                } else {
                    this.draw_lines(fArray, n3, 1, 1, 4);
                }
                this.draw_lines(fArray, n3 - 2, 3, n2, 0);
                break;
            }
            case 256: {
                if (this.isConvex()) {
                    if (this.fill) {
                        this.polygon.render();
                        if (this.stroke) {
                            this.polygon.unexpand();
                        }
                    }
                    if (!this.stroke) break;
                    this.draw_lines(fArray, n3 - 1, 1, 1, 0);
                    this.svertices[0] = fArray[n3 - 1];
                    this.svertices[1] = fArray[0];
                    this.draw_lines(this.svertices, 1, 1, 1, 0);
                    break;
                }
                if (this.fill) {
                    boolean bl = this.smooth;
                    if (this.stroke) {
                        this.smooth = false;
                    }
                    this.concaveRender();
                    if (this.stroke) {
                        this.smooth = bl;
                    }
                }
                if (!this.stroke) break;
                this.draw_lines(fArray, n3 - 1, 1, 1, 0);
                this.svertices[0] = fArray[n3 - 1];
                this.svertices[1] = fArray[0];
                this.draw_lines(this.svertices, 1, 1, 1, 0);
                break;
            }
        }
        this.shape = 0;
    }

    private final boolean isConvex() {
        float[][] fArray = this.polygon.vertices;
        int n = this.polygon.vertexCount;
        int n2 = 0;
        if (n < 3) {
            return true;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = (n3 + 1) % n;
            int n5 = (n3 + 2) % n;
            float f = (fArray[n4][0] - fArray[n3][0]) * (fArray[n5][1] - fArray[n4][1]);
            if ((f -= (fArray[n4][1] - fArray[n3][1]) * (fArray[n5][0] - fArray[n4][0])) < 0.0f) {
                n2 |= 1;
            } else if (f > 0.0f) {
                n2 |= 2;
            }
            if (n2 == 3) {
                return false;
            }
            ++n3;
        }
        if (n2 != 0) {
            return true;
        }
        return true;
    }

    private final void concaveRender() {
        float[][] fArray = this.polygon.vertices;
        if (this.tpolygon == null) {
            this.tpolygon = new PPolygon(this);
            this.tpolygon_vertex_order = new int[this.TPOLYGON_MAX_VERTICES];
        }
        this.tpolygon.reset(3);
        if (this.textureImage != null) {
            this.tpolygon.texture(this.textureImage);
        }
        this.tpolygon.interpX = this.polygon.interpX;
        this.tpolygon.interpZ = this.polygon.interpZ;
        this.tpolygon.interpUV = this.polygon.interpUV;
        this.tpolygon.interpARGB = this.polygon.interpARGB;
        boolean bl = false;
        int n = this.polygon.vertexCount;
        float[] fArray2 = new float[]{fArray[0][0], fArray[0][1]};
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (fArray[n3][1] < fArray2[1] || fArray[n3][1] == fArray2[1] && fArray[n3][0] > fArray2[0]) {
                n2 = n3;
                fArray2[0] = fArray[n2][0];
                fArray2[1] = fArray[n2][1];
            }
            ++n3;
        }
        float[] fArray3 = new float[2];
        float[] fArray4 = new float[2];
        float[] fArray5 = new float[2];
        int n4 = (n2 + (n - 1)) % n;
        int n5 = 0;
        while (n5 < 2) {
            fArray3[n5] = fArray[n4][n5];
            fArray4[n5] = fArray[n2][n5];
            fArray5[n5] = fArray[(n2 + 1) % n][n5];
            ++n5;
        }
        float f = fArray3[0] * fArray4[1] - fArray3[1] * fArray4[0] + fArray3[1] * fArray5[0] - fArray3[0] * fArray5[1] + fArray4[0] * fArray5[1] - fArray5[0] * fArray4[1];
        bl = f > 0.0f;
        if (!bl) {
            n5 = 0;
            while (n5 < n) {
                this.tpolygon_vertex_order[n5] = n5;
                ++n5;
            }
        } else {
            n5 = 0;
            while (n5 < n) {
                this.tpolygon_vertex_order[n5] = n - 1 - n5;
                ++n5;
            }
        }
        n5 = n;
        int n6 = 2 * n5;
        int n7 = 0;
        int n8 = n5 - 1;
        while (n5 > 2) {
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            int n9;
            boolean bl2 = true;
            if (n6-- <= 0) break;
            int n10 = n8;
            if (n5 <= n10) {
                n10 = 0;
            }
            if (n5 <= (n8 = n10 + 1)) {
                n8 = 0;
            }
            if (n5 <= (n9 = n8 + 1)) {
                n9 = 0;
            }
            if (1.0E-4f > ((f7 = -fArray[this.tpolygon_vertex_order[n8]][0]) - (f6 = -fArray[this.tpolygon_vertex_order[n10]][0])) * ((f5 = fArray[this.tpolygon_vertex_order[n9]][1]) - (f4 = fArray[this.tpolygon_vertex_order[n10]][1])) - ((f3 = fArray[this.tpolygon_vertex_order[n8]][1]) - f4) * ((f2 = -fArray[this.tpolygon_vertex_order[n9]][0]) - f6)) continue;
            int n11 = 0;
            while (n11 < n5) {
                if (n11 != n10 && n11 != n8 && n11 != n9) {
                    float f8 = -fArray[this.tpolygon_vertex_order[n11]][0];
                    float f9 = fArray[this.tpolygon_vertex_order[n11]][1];
                    float f10 = f2 - f7;
                    float f11 = f5 - f3;
                    float f12 = f6 - f2;
                    float f13 = f4 - f5;
                    float f14 = f7 - f6;
                    float f15 = f3 - f4;
                    float f16 = f8 - f6;
                    float f17 = f9 - f4;
                    float f18 = f8 - f7;
                    float f19 = f9 - f3;
                    float f20 = f8 - f2;
                    float f21 = f9 - f5;
                    float f22 = f10 * f19 - f11 * f18;
                    float f23 = f14 * f17 - f15 * f16;
                    float f24 = f12 * f21 - f13 * f20;
                    if (f22 >= 0.0f && f24 >= 0.0f && f23 >= 0.0f) {
                        bl2 = false;
                    }
                }
                ++n11;
            }
            if (!bl2) continue;
            int[] nArray = new int[]{this.tpolygon_vertex_order[n10], this.tpolygon_vertex_order[n8], this.tpolygon_vertex_order[n9]};
            int n12 = 0;
            while (n12 < 3) {
                float[] fArray6 = this.polygon.vertices[nArray[n12]];
                float[] fArray7 = this.tpolygon.vertices[n12];
                int n13 = 0;
                while (n13 < 36) {
                    fArray7[n13] = fArray6[n13];
                    ++n13;
                }
                ++n12;
            }
            this.tpolygon.render();
            ++n7;
            int n14 = n8;
            int n15 = n8 + 1;
            while (n15 < n5) {
                this.tpolygon_vertex_order[n14] = this.tpolygon_vertex_order[n15];
                ++n14;
                ++n15;
            }
            n6 = 2 * --n5;
        }
    }

    protected void rectImpl(float f, float f2, float f3, float f4) {
        if (this.untransformed() && !this.fillAlpha) {
            int n = (int)f;
            int n2 = (int)f2;
            int n3 = (int)f3;
            int n4 = (int)f4;
            this.rectImplFillUntranSolidRGB(n, n2, n3, n4);
            if (this.stroke) {
                if (this.strokeWeight == 1.0f) {
                    this.thin_flat_line(n, n2, n3, n2);
                    this.thin_flat_line(n3, n2, n3, n4);
                    this.thin_flat_line(n3, n4, n, n4);
                    this.thin_flat_line(n, n4, n, n2);
                } else {
                    this.thick_flat_line(n, n2, this.fillR, this.fillG, this.fillB, this.fillA, n3, n2, this.fillR, this.fillG, this.fillB, this.fillA);
                    this.thick_flat_line(n3, n2, this.fillR, this.fillG, this.fillB, this.fillA, n3, n4, this.fillR, this.fillG, this.fillB, this.fillA);
                    this.thick_flat_line(n3, n4, this.fillR, this.fillG, this.fillB, this.fillA, n, n4, this.fillR, this.fillG, this.fillB, this.fillA);
                    this.thick_flat_line(n, n4, this.fillR, this.fillG, this.fillB, this.fillA, n, n2, this.fillR, this.fillG, this.fillB, this.fillA);
                }
            }
        } else {
            this.beginShape(128);
            this.vertex(f, f2);
            this.vertex(f3, f2);
            this.vertex(f3, f4);
            this.vertex(f, f4);
            this.endShape();
        }
    }

    private final void rectImplFillUntranSolidRGB(int n, int n2, int n3, int n4) {
        int n5;
        if (n4 < n2) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        if (n3 < n) {
            n5 = n;
            n = n3;
            n3 = n5;
        }
        if (n > this.width1 || n3 < 0 || n2 > this.height1 || n4 < 0) {
            return;
        }
        n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n7 > this.width) {
            n7 = this.width;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n8 > this.height) {
            n8 = this.height;
        }
        int n9 = n7 - n5;
        int n10 = n8 - n6;
        int[] nArray = new int[n9];
        int n11 = 0;
        while (n11 < n9) {
            nArray[n11] = this.fillColor;
            ++n11;
        }
        n11 = n6 * this.width + n5;
        int n12 = 0;
        while (n12 < n10) {
            System.arraycopy(nArray, 0, this.pixels, n11, n9);
            n11 += this.width;
            ++n12;
        }
        nArray = null;
    }

    public void ellipseImpl(float f, float f2, float f3, float f4) {
        if (!this.smooth && this.strokeWeight == 1.0f && !this.fillAlpha && !this.strokeAlpha && this.untransformed()) {
            float f5 = f3 / 2.0f;
            float f6 = f4 / 2.0f;
            int n = (int)(f + f5);
            int n2 = (int)(f2 + f6);
            if (f5 == f6) {
                this.flat_circle(n, n2, (int)f5);
            } else {
                this.flat_ellipse(n, n2, (int)f5, (int)f6);
            }
        } else {
            super.ellipseImpl(f, f2, f3, f4);
        }
    }

    private final void flat_circle(int n, int n2, int n3) {
        if (this.unwarped()) {
            float f = this.m00 * (float)n + this.m01 * (float)n2 + this.m02;
            float f2 = this.m10 * (float)n + this.m11 * (float)n2 + this.m12;
            n = (int)f;
            n2 = (int)f2;
        }
        if (this.fill) {
            this.flat_circle_fill(n, n2, n3);
        }
        if (this.stroke) {
            this.flat_circle_stroke(n, n2, n3);
        }
    }

    private final void flat_circle_stroke(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n3;
        int n6 = 1;
        int n7 = 2 * n3 - 1;
        int n8 = 0;
        while (n4 < n5) {
            this.thin_point(n + n4, n2 + n5, 0.0f, this.strokeColor);
            this.thin_point(n + n5, n2 - n4, 0.0f, this.strokeColor);
            this.thin_point(n - n4, n2 - n5, 0.0f, this.strokeColor);
            this.thin_point(n - n5, n2 + n4, 0.0f, this.strokeColor);
            ++n4;
            if (n7 < 2 * (n8 += (n6 += 2))) {
                --n5;
                n8 -= n7;
                n7 -= 2;
            }
            if (n4 > n5) break;
            this.thin_point(n + n5, n2 + n4, 0.0f, this.strokeColor);
            this.thin_point(n + n4, n2 - n5, 0.0f, this.strokeColor);
            this.thin_point(n - n5, n2 - n4, 0.0f, this.strokeColor);
            this.thin_point(n - n4, n2 + n5, 0.0f, this.strokeColor);
        }
    }

    private final void flat_circle_fill(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n3;
        int n6 = 1;
        int n7 = 2 * n3 - 1;
        int n8 = 0;
        while (n4 < n5) {
            int n9 = n;
            while (n9 < n + n4) {
                this.thin_point(n9, n2 + n5, 0.0f, this.fillColor);
                ++n9;
            }
            n9 = n;
            while (n9 < n + n5) {
                this.thin_point(n9, n2 - n4, 0.0f, this.fillColor);
                ++n9;
            }
            n9 = n - n4;
            while (n9 < n) {
                this.thin_point(n9, n2 - n5, 0.0f, this.fillColor);
                ++n9;
            }
            n9 = n - n5;
            while (n9 < n) {
                this.thin_point(n9, n2 + n4, 0.0f, this.fillColor);
                ++n9;
            }
            ++n4;
            if (n7 < 2 * (n8 += (n6 += 2))) {
                --n5;
                n8 -= n7;
                n7 -= 2;
            }
            if (n4 > n5) break;
            n9 = n;
            while (n9 < n + n5) {
                this.thin_point(n9, n2 + n4, 0.0f, this.fillColor);
                ++n9;
            }
            n9 = n;
            while (n9 < n + n4) {
                this.thin_point(n9, n2 - n5, 0.0f, this.fillColor);
                ++n9;
            }
            n9 = n - n5;
            while (n9 < n) {
                this.thin_point(n9, n2 - n4, 0.0f, this.fillColor);
                ++n9;
            }
            n9 = n - n4;
            while (n9 < n) {
                this.thin_point(n9, n2 + n5, 0.0f, this.fillColor);
                ++n9;
            }
        }
    }

    private final void flat_ellipse_symmetry(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            int n5 = n - n3 + 1;
            while (n5 < n + n3) {
                this.thin_point(n5, n2 - n4, 0.0f, this.fillColor);
                this.thin_point(n5, n2 + n4, 0.0f, this.fillColor);
                ++n5;
            }
        } else {
            this.thin_point(n - n3, n2 + n4, 0.0f, this.strokeColor);
            this.thin_point(n + n3, n2 + n4, 0.0f, this.strokeColor);
            this.thin_point(n - n3, n2 - n4, 0.0f, this.strokeColor);
            this.thin_point(n + n3, n2 - n4, 0.0f, this.strokeColor);
        }
    }

    private final void flat_ellipse_internal(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 * n3;
        int n6 = n4 * n4;
        int n7 = 0;
        int n8 = n4;
        int n9 = n5 * (1 - 2 * n4) + 2 * n6;
        int n10 = n6 - 2 * n5 * (2 * n4 - 1);
        this.flat_ellipse_symmetry(n, n2, n7, n8, bl);
        do {
            if (n9 < 0) {
                n9 += 2 * n6 * (2 * n7 + 3);
                n10 += 4 * n6 * (n7 + 1);
                ++n7;
            } else if (n10 < 0) {
                n9 += 2 * n6 * (2 * n7 + 3) - 4 * n5 * (n8 - 1);
                n10 += 4 * n6 * (n7 + 1) - 2 * n5 * (2 * n8 - 3);
                ++n7;
                --n8;
            } else {
                n9 -= 4 * n5 * (n8 - 1);
                n10 -= 2 * n5 * (2 * n8 - 3);
                --n8;
            }
            this.flat_ellipse_symmetry(n, n2, n7, n8, bl);
        } while (n8 > 0);
    }

    private final void flat_ellipse(int n, int n2, int n3, int n4) {
        if (this.unwarped()) {
            float f = this.m00 * (float)n + this.m01 * (float)n2 + this.m02;
            float f2 = this.m10 * (float)n + this.m11 * (float)n2 + this.m12;
            n = (int)f;
            n2 = (int)f2;
        }
        if (this.fill) {
            this.flat_ellipse_internal(n, n2, n3, n4, true);
        }
        if (this.stroke) {
            this.flat_ellipse_internal(n, n2, n3, n4, false);
        }
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.depthErrorXYZ("bezier");
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.depthErrorXYZ("curve");
    }

    protected void imageImpl(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        if (f3 - f == (float)pImage.width && f4 - f2 == (float)pImage.height && !this.tint && this.unwarped()) {
            this.flat_image(pImage, (int)(f + this.m02), (int)(f2 + this.m12), n, n2, n3, n4);
        } else {
            super.imageImpl(pImage, f, f2, f3, f4, n, n2, n3, n4);
        }
    }

    private final void flat_image(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6) {
        block12: {
            int n7;
            int n8;
            int n9;
            int n10;
            block13: {
                block11: {
                    if (this.imageMode == 3) {
                        n -= pImage.width / 2;
                        n2 -= pImage.height / 2;
                    }
                    n10 = n + pImage.width;
                    n9 = n2 + pImage.height;
                    if (n > this.width1 || n10 < 0 || n2 > this.height1 || n9 < 0) {
                        return;
                    }
                    if (n < 0) {
                        n3 -= n;
                        n = 0;
                    }
                    if (n2 < 0) {
                        n4 -= n2;
                        n2 = 0;
                    }
                    if (n10 > this.width) {
                        n5 -= n10 - this.width;
                        n10 = this.width;
                    }
                    if (n9 > this.height) {
                        n6 -= n9 - this.height;
                        n9 = this.height;
                    }
                    n8 = n4 * pImage.width + n3;
                    n7 = n2 * this.width;
                    if (pImage.format != 2) break block11;
                    int n11 = n2;
                    while (n11 < n9) {
                        int n12 = 0;
                        int n13 = n;
                        while (n13 < n10) {
                            this.pixels[n7 + n13] = PGraphics2D._blend(this.pixels[n7 + n13], pImage.pixels[n8 + n12], pImage.pixels[n8 + n12++] >>> 24);
                            ++n13;
                        }
                        n8 += pImage.width;
                        n7 += this.width;
                        ++n11;
                    }
                    break block12;
                }
                if (pImage.format != 4) break block13;
                int n14 = n2;
                while (n14 < n9) {
                    int n15 = 0;
                    int n16 = n;
                    while (n16 < n10) {
                        this.pixels[n7 + n16] = PGraphics2D._blend(this.pixels[n7 + n16], this.fillColor, pImage.pixels[n8 + n15++]);
                        ++n16;
                    }
                    n8 += pImage.width;
                    n7 += this.width;
                    ++n14;
                }
                break block12;
            }
            if (pImage.format != 1) break block12;
            n7 += n;
            int n17 = n10 - n;
            int n18 = n2;
            while (n18 < n9) {
                System.arraycopy(pImage.pixels, n8, this.pixels, n7, n17);
                n8 += pImage.width;
                n7 += this.width;
                ++n18;
            }
        }
    }

    private final void thin_pointAt(int n, int n2, float f, int n3) {
        int n4 = n2 * this.width + n;
        this.pixels[n4] = n3;
        this.zbuffer[n4] = f;
    }

    private final void thin_pointAtIndex(int n, float f, int n2) {
        this.pixels[n] = n2;
        this.zbuffer[n] = f;
    }

    private final void thick_point(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.spolygon.reset(4);
        this.spolygon.interpARGB = false;
        float f8 = this.strokeWeight / 2.0f;
        float[] fArray = this.spolygon.vertices[0];
        fArray[0] = f - f8;
        fArray[1] = f2 - f8;
        fArray[2] = f3;
        fArray[3] = f4;
        fArray[4] = f5;
        fArray[5] = f6;
        fArray[6] = f7;
        fArray = this.spolygon.vertices[1];
        fArray[0] = f + f8;
        fArray[1] = f2 - f8;
        fArray[2] = f3;
        fArray = this.spolygon.vertices[2];
        fArray[0] = f + f8;
        fArray[1] = f2 + f8;
        fArray[2] = f3;
        fArray = this.spolygon.vertices[3];
        fArray[0] = f - f8;
        fArray[1] = f2 + f8;
        fArray[2] = f3;
        this.spolygon.render();
    }

    private final void thin_flat_line(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = this.thin_flat_lineClipCode(n, n2);
        if ((n11 & (n10 = this.thin_flat_lineClipCode(n3, n4))) != 0) {
            return;
        }
        int n12 = n11 | n10;
        if (n12 != 0) {
            float f = 0.0f;
            float f2 = 1.0f;
            float f3 = 0.0f;
            n9 = 0;
            while (n9 < 4) {
                if ((n12 >> n9) % 2 == 1) {
                    f3 = this.thin_flat_lineSlope(n, n2, n3, n4, n9 + 1);
                    if ((n11 >> n9) % 2 == 1) {
                        f = Math.max(f3, f);
                    } else {
                        f2 = Math.min(f3, f2);
                    }
                }
                ++n9;
            }
            if (f > f2) {
                return;
            }
            n8 = (int)((float)n + f * (float)(n3 - n));
            n7 = (int)((float)n2 + f * (float)(n4 - n2));
            n6 = (int)((float)n + f2 * (float)(n3 - n));
            n5 = (int)((float)n2 + f2 * (float)(n4 - n2));
        } else {
            n8 = n;
            n6 = n3;
            n7 = n2;
            n5 = n4;
        }
        n12 = 0;
        int n13 = n5 - n7;
        int n14 = n6 - n8;
        if (Math.abs(n13) > Math.abs(n14)) {
            int n15 = n13;
            n13 = n14;
            n14 = n15;
            n12 = 1;
        }
        int n16 = n14 == 0 ? 0 : (n13 << 16) / n14;
        if (n8 == n6) {
            if (n7 > n5) {
                n9 = n7;
                n7 = n5;
                n5 = n9;
            }
            n9 = n7 * this.width + n8;
            int n17 = n7;
            while (n17 <= n5) {
                this.thin_pointAtIndex(n9, 0.0f, this.strokeColor);
                n9 += this.width;
                ++n17;
            }
            return;
        }
        if (n7 == n5) {
            if (n8 > n6) {
                n9 = n8;
                n8 = n6;
                n6 = n9;
            }
            n9 = n7 * this.width + n8;
            int n18 = n8;
            while (n18 <= n6) {
                this.thin_pointAtIndex(n9++, 0.0f, this.strokeColor);
                ++n18;
            }
            return;
        }
        if (n12 != 0) {
            if (n14 > 0) {
                n14 += n7;
                n9 = 32768 + (n8 << 16);
                while (n7 <= n14) {
                    this.thin_pointAt(n9 >> 16, n7, 0.0f, this.strokeColor);
                    n9 += n16;
                    ++n7;
                }
                return;
            }
            n14 += n7;
            n9 = 32768 + (n8 << 16);
            while (n7 >= n14) {
                this.thin_pointAt(n9 >> 16, n7, 0.0f, this.strokeColor);
                n9 -= n16;
                --n7;
            }
            return;
        }
        if (n14 > 0) {
            n14 += n8;
            n9 = 32768 + (n7 << 16);
            while (n8 <= n14) {
                this.thin_pointAt(n8, n9 >> 16, 0.0f, this.strokeColor);
                n9 += n16;
                ++n8;
            }
            return;
        }
        n14 += n8;
        n9 = 32768 + (n7 << 16);
        while (n8 >= n14) {
            this.thin_pointAt(n8, n9 >> 16, 0.0f, this.strokeColor);
            n9 -= n16;
            --n8;
        }
    }

    private final int thin_flat_lineClipCode(float f, float f2) {
        int n = (f2 < 0.0f ? 8 : 0) | (f2 > (float)this.height1 ? 4 : 0) | (f < 0.0f ? 2 : 0);
        int n2 = 0;
        if (f > (float)this.width1) {
            n2 = 1;
        }
        return n | n2;
    }

    private final float thin_flat_lineSlope(float f, float f2, float f3, float f4, int n) {
        switch (n) {
            case 4: {
                return -f2 / (f4 - f2);
            }
            case 3: {
                return ((float)this.height1 - f2) / (f4 - f2);
            }
            case 2: {
                return -f / (f3 - f);
            }
            case 1: {
                return ((float)this.width1 - f) / (f3 - f);
            }
        }
        return -1.0f;
    }

    private final boolean flat_line_retribution(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        return false;
    }

    private final void thick_flat_line(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        boolean bl = false;
        if (f3 != f9 || f4 != f10 || f5 != f11 || f6 != f12) {
            bl = true;
        }
        this.spolygon.interpARGB = bl;
        this.spolygon.interpZ = false;
        if (!this.spolygon.interpARGB && this.flat_line_retribution(f, f2, f7, f8, f3, f4, f5)) {
            return;
        }
        float f13 = f7 - f + 1.0E-4f;
        float f14 = f8 - f2 + 1.0E-4f;
        float f15 = PGraphics2D.sqrt(f13 * f13 + f14 * f14);
        float f16 = this.strokeWeight / f15;
        float f17 = f16 * f14;
        float f18 = f16 * f13;
        float f19 = f16 * f14;
        float f20 = f16 * f13;
        this.spolygon.reset(4);
        float[] fArray = this.spolygon.vertices[0];
        fArray[0] = f + f17;
        fArray[1] = f2 - f18;
        fArray[3] = f3;
        fArray[4] = f4;
        fArray[5] = f5;
        fArray[6] = f6;
        fArray = this.spolygon.vertices[1];
        fArray[0] = f - f17;
        fArray[1] = f2 + f18;
        fArray[3] = f3;
        fArray[4] = f4;
        fArray[5] = f5;
        fArray[6] = f6;
        fArray = this.spolygon.vertices[2];
        fArray[0] = f7 - f19;
        fArray[1] = f8 + f20;
        fArray[3] = f9;
        fArray[4] = f10;
        fArray[5] = f11;
        fArray[6] = f12;
        fArray = this.spolygon.vertices[3];
        fArray[0] = f7 + f19;
        fArray[1] = f8 - f20;
        fArray[3] = f9;
        fArray[4] = f10;
        fArray[5] = f11;
        fArray[6] = f12;
        this.spolygon.render();
    }

    private final void draw_lines(float[][] fArray, int n, int n2, int n3, int n4) {
        if (this.strokeWeight < 2.0f) {
            int n5 = 0;
            while (n5 < n) {
                if (n4 == 0 || (n5 + n2) % n4 != 0) {
                    float[] fArray2 = fArray[n5];
                    float[] fArray3 = fArray[n5 + n2];
                    if (this.line == null) {
                        this.line = new PLine(this);
                    }
                    this.line.reset();
                    this.line.setIntensities(fArray2[12], fArray2[13], fArray2[14], fArray2[15], fArray3[12], fArray3[13], fArray3[14], fArray3[15]);
                    this.line.setVertices(fArray2[0], fArray2[1], fArray2[2], fArray3[0], fArray3[1], fArray3[2]);
                    this.line.draw();
                }
                n5 += n3;
            }
        } else if (this.strokeWeight < 2.0f && !this.strokeChanged) {
            int n6 = 0;
            while (n6 < n) {
                if (n4 == 0 || (n6 + n2) % n4 != 0) {
                    this.thin_flat_line((int)fArray[n6][0], (int)fArray[n6][1], (int)fArray[n6 + n2][0], (int)fArray[n6 + n2][1]);
                }
                n6 += n3;
            }
        } else {
            int n7 = 0;
            while (n7 < n) {
                if (n4 == 0 || (n7 + n2) % n4 != 0) {
                    float[] fArray4 = fArray[n7];
                    float[] fArray5 = fArray[n7 + n2];
                    this.thick_flat_line(fArray4[0], fArray4[1], fArray4[12], fArray4[13], fArray4[14], fArray4[15], fArray5[0], fArray5[1], fArray5[12], fArray5[13], fArray5[14], fArray5[15]);
                }
                n7 += n3;
            }
        }
    }

    private final void thin_point(int n, int n2, float f, int n3) {
        if (n < 0 || n > this.width1 || n2 < 0 || n2 > this.height1) {
            return;
        }
        int n4 = n2 * this.width + n;
        if ((n3 & 0xFF000000) == -16777216) {
            this.pixels[n4] = n3;
        } else {
            int n5 = n3 >> 24 & 0xFF;
            int n6 = n5 ^ 0xFF;
            int n7 = this.strokeColor;
            int n8 = this.pixels[n4];
            int n9 = n6 * (n8 >> 16 & 0xFF) + n5 * (n7 >> 16 & 0xFF) & 0xFF00;
            int n10 = n6 * (n8 >> 8 & 0xFF) + n5 * (n7 >> 8 & 0xFF) & 0xFF00;
            int n11 = n6 * (n8 & 0xFF) + n5 * (n7 & 0xFF) >> 8;
            this.pixels[n4] = 0xFF000000 | n9 << 8 | n10 | n11;
        }
        this.zbuffer[n4] = f;
    }

    protected void clear() {
        int n = 0;
        while (n < this.pixelCount) {
            this.pixels[n] = this.backgroundColor;
            ++n;
        }
    }

    private final boolean untransformed() {
        boolean bl = false;
        if (this.m00 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f && this.m12 == 0.0f) {
            bl = true;
        }
        return bl;
    }

    private final boolean unwarped() {
        boolean bl = false;
        if (this.m00 == 1.0f && this.m01 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f) {
            bl = true;
        }
        return bl;
    }

    private final void calc_lighting(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float[] fArray, int n) {
        fArray[n] = f;
        fArray[n + 1] = f2;
        fArray[n + 2] = f3;
    }

    private static final int float_color(float f, float f2, float f3) {
        return 0xFF000000 | (int)(255.0f * f) << 16 | (int)(255.0f * f2) << 8 | (int)(255.0f * f3);
    }

    public static final int _blend(int n, int n2, int n3) {
        n3 = n3 * (n2 >>> 24) >> 8;
        int n4 = n3 ^ 0xFF;
        int n5 = n4 * (n >> 16 & 0xFF) + n3 * (n2 >> 16 & 0xFF) & 0xFF00;
        int n6 = n4 * (n >> 8 & 0xFF) + n3 * (n2 >> 8 & 0xFF) & 0xFF00;
        int n7 = n4 * (n & 0xFF) + n3 * (n2 & 0xFF) >> 8;
        return 0xFF000000 | n5 << 8 | n6 | n7;
    }

    private final /* synthetic */ void this() {
        this.TPOLYGON_MAX_VERTICES = 512;
        this.strokeChanged = true;
        this.fillChanged = true;
        this.cvertex = new float[128][36];
    }

    protected PGraphics2D() {
        this.this();
    }

    public PGraphics2D(int n, int n2, PApplet pApplet) {
        super(n, n2, pApplet);
        this.this();
    }
}

