/*
 * Decompiled with CFR 0.152.
 */
package treemap;

import java.util.Vector;
import treemap.MapItem;
import treemap.MapLayout;
import treemap.MapModel;
import treemap.Mappable;
import treemap.Rect;

public class TreeModel
implements MapModel {
    private Mappable mapItem;
    private Mappable[] childItems;
    private Mappable[] cachedTreeItems;
    private MapModel[] cachedLeafModels;
    private TreeModel parent;
    private Vector children = new Vector();

    public TreeModel() {
        this.mapItem = new MapItem();
    }

    public TreeModel(Mappable mapItem) {
        this.mapItem = mapItem;
    }

    public void setOrder(int order) {
        this.mapItem.setOrder(order);
    }

    public MapModel[] getLeafModels() {
        if (this.cachedLeafModels != null) {
            return this.cachedLeafModels;
        }
        Vector v = new Vector();
        this.addLeafModels(v);
        int n = v.size();
        Object[] m = new MapModel[n];
        v.copyInto(m);
        this.cachedLeafModels = m;
        return m;
    }

    private Vector addLeafModels(Vector v) {
        if (!this.hasChildren()) {
            System.err.println("Somehow tried to get child model for leaf!!!");
            return v;
        }
        if (!this.getChild(0).hasChildren()) {
            v.addElement(this);
        } else {
            int i = this.childCount() - 1;
            while (i >= 0) {
                this.getChild(i).addLeafModels(v);
                --i;
            }
        }
        return v;
    }

    public int depth() {
        if (this.parent == null) {
            return 0;
        }
        return 1 + this.parent.depth();
    }

    public void layout(MapLayout tiling) {
        this.layout(tiling, this.mapItem.getBounds());
    }

    public void layout(MapLayout tiling, Rect bounds) {
        this.mapItem.setBounds(bounds);
        if (!this.hasChildren()) {
            return;
        }
        tiling.layout(this, bounds);
        int i = this.childCount() - 1;
        while (i >= 0) {
            this.getChild(i).layout(tiling);
            --i;
        }
    }

    public Mappable[] getTreeItems() {
        if (this.cachedTreeItems != null) {
            return this.cachedTreeItems;
        }
        Vector v = new Vector();
        this.addTreeItems(v);
        int n = v.size();
        Object[] m = new Mappable[n];
        v.copyInto(m);
        this.cachedTreeItems = m;
        return m;
    }

    private void addTreeItems(Vector v) {
        if (!this.hasChildren()) {
            v.addElement(this.mapItem);
        } else {
            int i = this.childCount() - 1;
            while (i >= 0) {
                this.getChild(i).addTreeItems(v);
                --i;
            }
        }
    }

    public Mappable[] getItems() {
        if (this.childItems != null) {
            return this.childItems;
        }
        int n = this.childCount();
        this.childItems = new Mappable[n];
        int i = 0;
        while (i < n) {
            this.childItems[i] = this.getChild(i).getMapItem();
            this.childItems[i].setDepth(1 + this.depth());
            ++i;
        }
        return this.childItems;
    }

    public Mappable getMapItem() {
        return this.mapItem;
    }

    public void addChild(TreeModel child) {
        child.setParent(this);
        this.children.addElement(child);
        this.childItems = null;
    }

    public void setParent(TreeModel parent) {
        TreeModel p = parent;
        while (p != null) {
            if (p == this) {
                throw new IllegalArgumentException("Circular ancestry!");
            }
            p = p.getParent();
        }
        this.parent = parent;
    }

    public TreeModel getParent() {
        return this.parent;
    }

    public int childCount() {
        return this.children.size();
    }

    public TreeModel getChild(int n) {
        return (TreeModel)this.children.elementAt(n);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void print() {
        this.print("");
    }

    private void print(String prefix) {
        System.out.println(String.valueOf(prefix) + "size=" + this.mapItem.getSize());
        int i = 0;
        while (i < this.childCount()) {
            this.getChild(i).print(String.valueOf(prefix) + "..");
            ++i;
        }
    }
}

